import pandas

# Stap 1: Lees de gegevens in het csv-bestand in een pandas DataFrame.
dataframe = pandas.read_csv("vgsales.csv")

# Stap 2: Zoek de top 5 best verkopende games op basis van wereldwijde verkopen.
top_5_games = dataframe.nlargest(5, "Global_Sales")
print("Top 5 best verkopende games:")
print(top_5_games)

# Stap 3: Maak een nieuwe DataFrame met alleen de games die zijn uitgegeven door Nintendo.
nintendo_games = dataframe[dataframe["Publisher"] == "Nintendo"]
print("Nintendo games:")
print(nintendo_games)

# Stap 4: Exporteer de Nintendo-games naar een CSV-bestand met de naam "nintendo_games.csv"
nintendo_games.to_csv("nintendo_games.csv", index=False)

# Stap 5: Bereken het gemiddelde aantal verkopen in Noord-Amerika (NA_Sales), Europa (EU_Sales) en Japan (JP_Sales).
gemiddelde_na_verkopen = dataframe["NA_Sales"].mean()
gemiddelde_eu_verkopen = dataframe["EU_Sales"].mean()
gemiddelde_jp_verkopen = dataframe["JP_Sales"].mean()
print("Gemiddelde verkopen in Noord-Amerika:", gemiddelde_na_verkopen)
print("Gemiddelde verkopen in Europa:", gemiddelde_eu_verkopen)
print("Gemiddelde verkopen in Japan:", gemiddelde_jp_verkopen)

# Stap 6: Zoek de game met de hoogste totale verkoop.
hoogste_totale_verkoop = dataframe.nlargest(1, "Global_Sales")
print("Game met hoogste totale verkoop:")
print(hoogste_totale_verkoop)

# Stap 7: Maak een nieuwe DataFrame met alleen de games die zijn uitgebracht na het jaar 2000.
games_na_2000 = dataframe[dataframe["Year"] > 2000]
print("Games uitgebracht na het jaar 2000:")
print(games_na_2000)